/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sct.dao.impl;

import com.quantumdata.sct.dao.exception.CreateException;
import com.quantumdata.sct.dao.exception.DAOException;
import com.quantumdata.sct.dao.exception.UpdateException;
import com.quantumdata.sct.dao.impl.AbstractXMLStorageDAO;
import com.quantumdata.sct.dao.interfaces.IPersistable;
import com.quantumdata.sct.dao.jaxb.Standard;
import com.quantumdata.sct.dao.jaxb.Standards;
import com.quantumdata.sct.dao.jaxb.StandardsType;
import com.quantumdata.sct.dao.jaxb.impl.StandardsImpl;
import com.quantumdata.sct.dao.jaxb.impl.StandardsTypeImpl;
import com.quantumdata.sct.dao.vo.StandardVO;
import com.quantumdata.sct.util.keygen.KeyGenerator;
import com.quantumdata.sct.util.keygen.RandTSKeyGenerator;

public class StandardDAO
extends AbstractXMLStorageDAO {
    private KeyGenerator keygen = RandTSKeyGenerator.instance();

    public void readCallback() throws DAOException {
        try {
            Standards standards = (Standards)this.daoObject;
            int n = 0;
            this.daoCollection.clear();
            for (Standard standard : standards.getStandardsCollection()) {
                this.daoCollection.put(standard.getId(), new Integer(n));
                ++n;
            }
            this.initialize = true;
        }
        catch (Exception exception) {
            this.initialize = false;
            throw new DAOException("Unable to load", null, exception);
        }
    }

    public Object getUniqueKey() {
        return this.keygen.generateUniqueKey();
    }

    public IPersistable getValueObjectForKey(Object object) throws CreateException {
        try {
            Integer n = (Integer)this.daoCollection.get(object);
            StandardsTypeImpl.StandardImpl standardImpl = this.get(n);
            return this.createPersistable(standardImpl);
        }
        catch (Exception exception) {
            throw new CreateException("Unable to create with key =" + object, null, exception);
        }
    }

    private final StandardsTypeImpl.StandardImpl get(Integer n) throws Exception {
        if (n == null) {
            throw new IllegalArgumentException("Invalid Index");
        }
        int n2 = ((Standards)this.daoObject).getStandardsCollection().size();
        if (n > n2) {
            throw new ArrayIndexOutOfBoundsException("Look up index value = " + n + " exceeds = " + n2);
        }
        StandardsTypeImpl.StandardImpl standardImpl = (StandardsTypeImpl.StandardImpl)((Standards)this.daoObject).getStandardsCollection().get(n);
        return standardImpl;
    }

    public IPersistable[] findByAll() throws Exception {
        int n = ((StandardsImpl)this.daoObject).getStandardsCollection().size();
        int n2 = 0;
        IPersistable[] iPersistableArray = new IPersistable[n];
        for (Standard standard : ((StandardsImpl)this.daoObject).getStandardsCollection()) {
            iPersistableArray[n2] = this.createPersistable(standard);
            ++n2;
        }
        return iPersistableArray;
    }

    public Object getUniqueKey(Object object) {
        Object object2 = null;
        if (object instanceof Standard) {
            Standard standard = (Standard)object;
            object2 = standard.getId();
        } else {
            object2 = this.getUniqueKey();
        }
        return object2;
    }

    public final IPersistable createPersistable(Object object) {
        StandardVO standardVO = new StandardVO();
        if (object instanceof Standard) {
            this.copyFrom((Standard)object, standardVO);
        }
        return standardVO;
    }

    protected void copyFrom(Standard standard, StandardVO standardVO) {
        standardVO.set_description(standard.getDescription());
        standardVO.set_name(standard.getName());
        standardVO.set_notation(standard.getNotation());
        standardVO.set_version(standard.getVersion());
        standardVO.setId(standard.getId());
    }

    protected void copyTo(Standard standard, StandardVO standardVO) {
        standard.setDescription(standardVO.get_description());
        standard.setLastUpdateTime(System.currentTimeMillis());
        standard.setName(standardVO.get_name());
        standard.setNotation(standardVO.get_notation());
        standard.setVersion(standardVO.get_version());
        standard.setId((String)standardVO.getId());
    }

    public final void update(IPersistable iPersistable) throws UpdateException {
        block4: {
            try {
                if (iPersistable instanceof StandardVO) {
                    StandardVO standardVO = (StandardVO)iPersistable;
                    if (this.daoCollection.containsKey(standardVO.getId()) && standardVO.isDirty()) {
                        Object v = this.daoCollection.get(standardVO.getId());
                        System.out.println(v.getClass().getName());
                        Integer n = (Integer)this.daoCollection.get(standardVO.getId());
                        StandardsTypeImpl.StandardImpl standardImpl = this.get(n);
                        this.copyTo(standardImpl, standardVO);
                    }
                    break block4;
                }
                throw new UpdateException("Invalid Object", null);
            }
            catch (Exception exception) {
                this.log(exception.getMessage());
                throw new UpdateException(exception.getMessage());
            }
        }
    }

    protected void updateObject(IPersistable iPersistable) {
        if (this.daoCollection.containsKey(iPersistable.getId())) {
            Integer n = (Integer)this.daoCollection.get(iPersistable.getId());
            Standard standard = (Standard)((Standards)this.daoObject).getStandardsCollection().get(n);
            this.copyTo(standard, (StandardVO)iPersistable);
        }
    }

    protected final IPersistable findByPrimaryKey(String string) {
        StandardVO standardVO = null;
        if (this.daoCollection.containsKey(string)) {
            Integer n = (Integer)this.daoCollection.get(string);
            Standard standard = (Standard)((Standards)this.daoObject).getStandardsCollection().get(n);
            StandardVO standardVO2 = new StandardVO();
            this.copyFrom(standard, standardVO2);
            standardVO = standardVO2;
        }
        return standardVO;
    }

    protected final void removeByPrimaryKey(Object object) throws DAOException {
        try {
            if (object instanceof String) {
                int n = (Integer)this.daoCollection.get(object);
                ((Standards)this.daoObject).getStandardsCollection().remove(n);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new DAOException(throwable.getMessage());
        }
    }

    public void add(IPersistable iPersistable, int n) throws CreateException {
        try {
            int n2 = ((Standards)this.daoObject).getStandardsCollection().size();
            if (!(iPersistable instanceof StandardVO) || n >= n2) {
                throw new Exception("Invalid parameters being passed");
            }
            StandardsType.Standard standard = this.factory.createStandardsTypeStandard();
            this.copyTo(standard, (StandardVO)iPersistable);
            ((Standards)this.daoObject).getStandardsCollection().add(n, standard);
            this.flush();
            this.readCallback();
        }
        catch (Exception exception) {
            throw new CreateException("Unable to add element = " + iPersistable.getId(), null, exception);
        }
    }

    public void add(IPersistable iPersistable) throws CreateException {
        try {
            if (!(iPersistable instanceof StandardVO)) {
                throw new Exception("Invalid Value Object being passed");
            }
            StandardsType.Standard standard = this.factory.createStandardsTypeStandard();
            this.copyTo(standard, (StandardVO)iPersistable);
            ((Standards)this.daoObject).getStandardsCollection().add(standard);
            this.flush();
            this.readCallback();
        }
        catch (Exception exception) {
            throw new CreateException("Unable to add element = " + iPersistable.getId(), null, exception);
        }
    }
}

